<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_bookings', '%s Booking Step %d', [$this->I18n->translate($data, 'Activity.name'), 1]));
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<?php if (empty($data['Activity']['is_hidden_activity'])): ?>
	<div class="row">
		<div class="col-xs-12 col-sm-4 col-sm-push-8">
			<?php if ($hasPrivateHirePackages === true && $data['Activity']['show_private_hire'] === true): ?>
				<div class="outline--secondary background--white padding-gutters-1_2">
					<div class="row">
						<div class="col-xs-12 col-md-6 md-plus-gutterless--right text-center">
							<h3 class="md-plus-left gutter-top"><?php echo __d('buzz_bookings', 'Want Private Hire?'); ?></h3>
						</div>

						<div class="col-xs-12 col-md-6">
							<?php
								echo $this->Fa->link(
									'chevron-circle-right fa-inline',
									__d('buzz_bookings', 'Book Now'),
									['action' => 'private_hire'],
									['class' => 'button button--fill md-plus-right']
								);
							?>
						</div>
					</div>
				</div>
				<div class="content__spacer"></div>
			<?php endif; ?>
		</div>
		<div class="col-xs-12 col-sm-8 col-sm-pull-4">
			<p><?php echo __d('buzz_bookings', 'Select the quantity of %s Packages for you, your family and friends', [$this->I18n->translate($data, 'Activity.name')]); ?></p>

			<div class="js-bookings-voucher-booking">
				<label class="left"><?php echo __d('buzz_bookings', 'Do you have a voucher?'); ?></label>
				<?php
					echo $this->Form->input(
						'vouchers',
						[
							'label' => __d('buzz_bookings', 'Yes'),
							'div' => 'input checkbox checkbox--custom js-bookings-toggle--vouchers',
							'type' => 'checkbox',
							'checked' => !empty($basket['Booking']['has_vouchers'])
						]
					);
				?>
			</div>
		</div>
	</div>
	<div class="toggle__content">
		<div class="row">
			<div class="col-xs-6 col-lg-3">
				<h3>Provider</h3>
			</div>

			<div class="col-xs-3 xs-gutterless--left col-lg-2">
				<h3>Voucher Number</h3>
			</div>

			<div class="col-xs-3 xs-gutterless--left col-lg-2 lg-gutterless--right">
				<h3>Expiry Date</h3>
			</div>
		</div>
		<script type="text/javascript">
			var vouchers = <?php echo json_encode($vouchers); ?>;
		</script>
		<?php
			if (!empty($basket['Booking']['has_vouchers'])):
				$numberOfVouchers = count(Hash::extract($basket, 'BookingItem.{n}.BookingItemVoucher.id'));
				$i = 0;
				foreach ($basket['BookingItem'] as $bookingItem):
					if (!empty($bookingItem['BookingItemVoucher'])):
						++$i;
						echo $this->element(
							'../Bookings/ajax_voucher_added',
							[
								'voucher' => $bookingItem['BookingItemVoucher'],
								'activityId' => $data['Activity']['id'],
								'hideButton' => $i < $numberOfVouchers || $isMultiExperience === true
							]
						);
					endif;
				endforeach;
			else:
				echo $this->element('../Bookings/ajax_voucher', ['activityId' => $data['Activity']['id']]);
			endif;
		?>
	</div>
<?php endif; ?>

<?php // If there is a multi-experience voucher in the basket we want to hide all the pacakges. ?>
<?php if ($isMultiExperience === false || empty($basket['Booking']['has_vouchers'])): ?>

	<?php echo $this->Form->create(null, ['class' => $isMultiExperience ? 'js-multi-experience' : null]); ?>

	<?php echo $this->Form->hidden('Booking.activity_id'); ?>

	<div class="content__spacer"></div>

	<div class="row">
		<div class="col-xs-12">
			<?php foreach ($data['ActivityPackage'] as $package): ?>
				<?php echo $this->element('BuzzBookings.Forms/activity_package', ['data' => $package]); ?>
				<div class="content__spacer"></div>
			<?php endforeach; ?>
		</div>
	</div>

	<div class="booking__actions">
		<div class="row">
			<div class="col-xs-6">
				<?php echo $this->Html->link(__d('buzz_bookings', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
			</div>

			<div class="col-xs-6">
				<?php echo $this->Form->button(__d('buzz_bookings', 'Proceed'), ['class' => 'button button--dark background--senary right']); ?>
			</div>
		</div>
	</div>

	<?php echo $this->Form->end(); ?>

<?php endif; ?>
