<?php
$this->extend('/Common/view');
$this->assign(
	'title',
	__d(
		'buzz_bookings',
		'%s Booking Step %d',
		[
			$basket['Booking']['is_private_hire'] ? __d('buzz_bookings', 'Private Hire') : $this->I18n->translate($basket, 'Activity.name'),
			3
		]
	)
);
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<?php echo $this->element('BuzzBookings.bookings_basket', ['data' => $basket]); ?>

<?php echo $this->Form->create(); ?>

<?php if (!empty($extras)): ?>

	<div class="row">
		<div class="col-xs-12">
			<h3><?php echo __d('buzz_bookings', 'Would you like to add extras to your adventure?'); ?></h3>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12">

			<?php foreach ($extras as $extra): ?>
				<?php echo $this->element('Forms/extra', ['data' => $extra, 'quantities' => $participants]); ?>
				<div class="content__spacer"></div>
			<?php endforeach; ?>

		</div>
	</div>

<?php endif; ?>

<?php if (!empty($bookableUpsells)): ?>

	<div class="row">
		<div class="col-xs-12">
			<h3><?php echo __d('buzz_bookings', 'Want to do more? We\'re offering an extra activity at a discounted price'); ?></h3>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12">

			<?php foreach ($bookableUpsells as $upsell): ?>
				<?php echo $this->element('BuzzBookings.Forms/upsell_package', ['data' => $upsell, 'quantities' => $participants]); ?>
				<div class="content__spacer"></div>
			<?php endforeach; ?>

		</div>
	</div>

<?php endif; ?>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_bookings', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php echo $this->Form->button(__d('buzz_bookings', 'Proceed'), ['class' => 'button button--dark background--senary right']); ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
