<div class="row">

	<div class="col-xs-6 col-lg-3">
		<?php echo $voucher['voucher_provider']; ?>
	</div>
	<div class="col-xs-3 xs-gutterless--left col-lg-2">
	<?php echo $voucher['voucher_code']; ?>
	</div>
	<div class="col-xs-3 xs-gutterless--left col-lg-2">
		<?php echo $this->Time->i18nFormat($voucher['expiry_date'], '%d/%m/%Y'); ?>
	</div>
	<div class="col-xs-10 col-lg-4">
		<?php echo $voucher['name']; ?>
	</div>
	<div class="col-xs-2 col-lg-1 text-center">
		<?php
			$removeUrl = [
				'action' => 'remove_voucher',
				$voucher['booking_item_id'],
				'ajax' => true
			];
			$removeClass = 'basket__delete js-bookings-remove-voucher';
			if ($isMultiExperience === true) {
				$removeUrl = [
					'action' => 'remove_vouchers',
					$activityId < 0 ? 1 : 0,
					'ajax' => false
				];
				$removeClass = 'basket__delete';
			}
			echo $this->Fa->link(
				'times-circle',
				null,
				$removeUrl,
				[
					'class' => $removeClass,
					'title' => __d('buzz_bookings', 'Remove')
				]
			);
		?>
	</div>
	<div class="content__spacer content__spacer--small"></div>

</div>

<?php if (empty($hideButton)): ?>
	<div class="row">
		<div class="col-xs-6 col-lg-3">
			<?php
				echo $this->Form->button(
					__d('buzz_bookings', 'I have another voucher') . ' <i class="fa fa-chevron-circle-right"></i>',
					[
						'class' => 'button button--fill button--dark background--senary js-bookings-add-voucher',
						'data-url' => $this->Html->url(['action' => 'voucher', $activityId, 'ajax' => true])
					]
				);
			?>
		</div>
	</div>
<?php endif; ?>


<?php if ($isMultiExperience === true): ?>

	<?php
		echo $this->Form->create(
			null,
			[
				'id' => false,
				'url' => ['action' => $isPrivateHire !== true ? 'packages' : 'private_hire', $activityId, 'ajax' => false]
			]
		);
	?>

	<?php echo $this->Form->hidden('Form.process', ['value' => 'vouchers']); ?>

	<div class="booking__actions">
		<div class="row">
			<div class="col-xs-6">
				<?php echo $this->Html->link(__d('buzz_bookings', 'I don\'t want to use a voucher'), ['action' => 'remove_vouchers', $activityId < 0 ? 1 : 0, 'ajax' => false], ['class' => 'button button--light background--septenary left']); ?>
			</div>

			<div class="col-xs-6">
				<?php echo $this->Form->button(__d('buzz_bookings', 'Proceed'), ['class' => 'button button--dark background--senary right']); ?>
			</div>
		</div>
	</div>

	<?php echo $this->Form->end(); ?>

<?php endif; ?>
