<?php

App::uses('BuzzBookingsAppModel', 'BuzzBookings.Model');

class BookingItemVoucher extends BuzzBookingsAppModel {

/**
 * Belongs to associations
 *
 * @var array
 */
	public $belongsTo = array(
		'BookingItem' => array(
			'className' => 'BuzzBookings.BookingItem'
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'voucher_code' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'expiry_date' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		)
	);

}
