<?php

App::uses('CakeEventListener', 'Event');

class BookingListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.Booking.completed' => 'confirmation',
			'Model.Booking.fallout' => 'fallout'
		);
	}

	public function confirmation(CakeEvent $Event) {
		$purchase = ClassRegistry::init('BuzzBookings.Booking')->getPurchase($Event->data['id']);
		// Send confirmation email
		$Controller = new Controller();
		$Controller->helpers = ['BuzzTranslate.I18n'];
		$View = new View($Controller);
		$View->set('data', $purchase);
		$details = $View->render('BuzzBookings./Bookings/email_basket', 'ajax');

		$Email = ClassRegistry::init('BuzzEmails.Email');
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzBookings.confirmation_email',
			[
				'salesRef' => $purchase['Booking']['sales_ref'],
				'details' => $details,
				'fullName' => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name'],
				'firstName' => $purchase['CustomerAddress']['first_name'],
				'lastName' => $purchase['CustomerAddress']['last_name'],
				'checkin' => $purchase['Booking']['check_in_time'],
				'date' => date('j F Y', strtotime($purchase['Booking']['booking_date'])),
				'time' => date('H:i', strtotime($purchase['Booking']['booking_date']))
			]
		);
		$Email->queueEmail(
			$email['Email']['subject'],
			$email['Email']['content'],
			array($purchase['CustomerAddress']['email'] => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name']),
			$email['Email']['from']
		);

		return;
	}

	public function fallout(CakeEvent $Event) {
		$Booking = ClassRegistry::init('BuzzBookings.Booking');
		$booking = $Booking->getBasket($Event->data['id']);
		// Send confirmation email
		$Controller = new Controller();
		$Controller->helpers = ['BuzzTranslate.I18n'];
		$View = new View($Controller);
		$View->set('data', $booking);
		$details = $View->render('BuzzBookings./Bookings/email_basket', 'ajax');

		$Email = ClassRegistry::init('BuzzEmails.Email');
		$email = $Email->generateEmailData(
			'BuzzBookings.fallout_email',
			[
				'details' => $details,
				'checkin' => $booking['Booking']['check_in_time'],
				'date' => CakeTime::i18nFormat($booking['Booking']['booking_date'], '%e %B %Y'),
				'time' => CakeTime::i18nFormat($booking['Booking']['booking_date'], '%H:%M'),
				'url' => Router::url([
					'plugin' => 'buzz_bookings',
					'controller' => 'bookings',
					'action' => 'restore',
					$booking['Booking']['id'],
					$Booking->generateSignature($booking['Booking'])
				], true)
			]
		);
		if ($email !== false) {
			$Email->queueEmail(
				$email['Email']['subject'],
				$email['Email']['content'],
				array($booking['Booking']['email'] => $booking['Booking']['email']),
				$email['Email']['from']
			);
		}

		// Tell the API that the customer has abandoned their booking.
		ClassRegistry::init('BuzzBookings.BookingApi')->abandonSale(
			$booking['Booking']['email'],
			$booking['Booking']['sales_ref'],
			Configure::read('Config.language')
		);

		return;
	}

}
