<?php

App::uses('BuzzBookingsAppController', 'BuzzBookings.Controller');

class ActivityPackagesController extends BuzzBookingsAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name',
				'description'
			)
		)
	);

	public function admin_edit($id = null) {
		parent::admin_edit($id);

		$ActivityPackage = $this->{$this->modelClass};
		// Exclude private hire and multi-experience packages.
		$conditions = [
			'ActivityPackage.participants >' => 0,
			'ActivityPackage.api_reference NOT LIKE' => '%,%'
		];
		if ($id !== null) {
			$conditions['ActivityPackage.id <>'] = $id;
		}
		$this->set('upsellExclusions', $ActivityPackage->find('list', compact('conditions')));

		$this->Translation->adminTranslationFormFields();
		$this->set('upsellFields', $this->_adminFormUpsellFields());
		$this->view = 'BuzzBookings./ActivityPackages/admin_form';

		return;
	}

	protected function _adminFormUpsellFields() {
		return array(
			'UpsellApplicableActivity.UpsellApplicableActivity' => array(
				'label' => __d('buzz_bookings', 'Upsell Applicable Activities'),
				'type' => 'multicheck'
			),
			'UpsellExclusion.UpsellExclusion' => array(
				'label' => __d('buzz_bookings', 'Upsell Exclude Packages'),
				'type' => 'multicheck'
			)
		);
	}

	/**
	 * Admin form fields
	 *
	 * @return array
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['ActivityPackage.participants']['type'] = 'select';

		return $fields;
	}

	/**
	 * Populate admin lookups
	 *
	 * @return void
	 */
	protected function _adminPopulateLookups() {
		$ActivityPackage = $this->{$this->modelClass};

		$activities = $ActivityPackage->Activity->find('list');
		$upsellApplicableActivities = $activities;
		if ($ActivityPackage->Activity->getMultiExperience()) {
			// Remove the multi-experience activity from upsell applicable
			// activities as there can't be any bookable upsells for
			// multi-experience bookings.
			unset($upsellApplicableActivities[$ActivityPackage->Activity->getMultiExperience()]);
		}
		$this->set(compact('activities', 'upsellApplicableActivities'));

		$participants = array_combine(range(1, 12), range(1, 12));
		array_unshift($participants, __d('buzz_bookings', 'Private Hire'));
		$this->set(compact('participants'));

		return;
	}

	/**
	 * Admin index paginate
	 *
	 * @return array
	 */
	protected function _adminIndexPaginate() {
		$conditions = $this->_processFilter();

		$paginate = array(
			'conditions' => $conditions,
			'contain' => array(
				'Activity'
			)
		);

		return $paginate;
	}

	/**
	 * Admin index columns
	 *
	 * @return array
	 */
	protected function _adminIndexColumns() {
		$ActivityPackage = $this->{$this->modelClass};

		$columns = parent::_adminIndexColumns();

		$newColumns = array(
			'Activity.name' => array(
				'label' => __d('buzz_bookings', 'Activity'),
				'type' => 'string'
			)
		);

		return ArrayUtil::addAfter($columns, 'ActivityPackage.name', $newColumns);
	}

	/**
	 * Filters
	 *
	 * @return array
	 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		unset($filters['Booking.name']);
		unset($filters['Booking.created']);
		unset($filters['Booking.modified']);

		$newFilters = array(
			'ActivityPackage.activity_id' => array(
				'label' => __d('buzz_bookings', 'Activity'),
				'type' => 'select',
				'compare' => array('ActivityPackage.activity_id' => "%s")
			)
		);

		return ArrayUtil::addAfter($filters, 'Booking.sales_ref', $newFilters);
	}

}
