<?php

App::uses('BuzzBookingsAppController', 'BuzzBookings.Controller');

class ActivitiesController extends BuzzBookingsAppController {

	public $components = array(
		'BuzzAdverts.Adverts',
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name',
				'content' => array(
					'type' => 'html'
				),
				'secondary_content' => array(
					'type' => 'html'
				)
			),
			'meta' => true
		)
	);

	public function __construct($request = null, $response = null) {
		$this->adminActions[] = 'admin_adverts';
		parent::__construct($request, $response);
	}

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'index',
			'view'
		));
	}

/**
 * Activities landing page
 *
 * @return void
 */
	public function index() {
		$activities = $this->Activity->getListed();

		if (count($activities) === 1 && !empty($activities[0]['Activity']['id'])) {
			return $this->redirect([
				'controller' => 'activities',
				'action' => 'view',
				$activities[0]['Activity']['id']
			]);
		}

		if (Configure::check('BuzzBookings.activities_page_id') === true) {
			$data = $this->assignPage(Configure::read('BuzzBookings.activities_page_id'));
		}

		// For BuzzGallery enabled sites set the gallery for the View.
		if (CakePlugin::loaded('BuzzGallery') === true && !empty($this->viewVars['data']['Page']['gallery_id'])) {
			$this->set(
				'gallery',
				$this->Page->Gallery->readForView($this->viewVars['data']['Page']['gallery_id'])
			);
		}

		$this->set(compact('activities'));
		$this->view = 'BuzzBookings./Activities/index';

		return;
	}

/**
 * Activity page
 *
 * @param int $id Activity ID
 * @return void
 */
	public function view($id) {
		$data = $this->Activity->readForView($id);

		// For BuzzGallery enabled sites set the gallery for the View.
		if (CakePlugin::loaded('BuzzGallery') === true && !empty($data['Activity']['gallery_id'])) {
			$this->set(
				'gallery',
				$this->Activity->Gallery->readForView($data['Activity']['gallery_id'])
			);
		}

		$activities = $this->Activity->getListed();

		$this->set(compact('activities', 'data'));
		$this->view = 'BuzzBookings./Activities/view';

		return;
	}

	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Adverts->setupAdvertAdminFields();
		$this->Translation->adminTranslationFormFields();
		return;
	}

/**
 * Admin form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['Activity.content']['type'] = 'html';
		$fields['Activity.secondary_content']['type'] = 'html';

		$fields['Activity.video_url']['label'] = __d('buzz_bookings', 'Video URL');

		if (CakePlugin::loaded('BuzzGallery') === true) {
			$galleryFields = array(
				'Activity.gallery_id' => array(
					'type' => 'select',
					'label' => __d('buzz_bookings', 'Gallery')
				)
			);
			$fields = ArrayUtil::addAfter($fields, 'Activity.theme_id', $galleryFields);
		}

		return $fields;
	}

/**
 * Populate admin lookups
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$Activity = $this->{$this->modelClass};

		$this->set('themes', $Activity->Theme->find('list'));

		if (CakePlugin::loaded('BuzzGallery') === true) {
			$this->set('galleries', $Activity->Gallery->find('list'));
		}

		return;
	}

	protected function _adminFormToolbar($id = null) {
		$toolbar = parent::_adminFormToolbar($id);

		$toolbar['Adverts'] = array(
			'url' => array('action' => 'adverts', $id),
			'icon' => 'bars'
		);

		return $toolbar;
	}

}
