<?php
$this->extend('/Common/view');
$this->assign(
	'title',
	__d(
		'buzz_bookings',
		'%s Booking Step %d',
		[
			$basket['Booking']['is_private_hire'] ? __d('buzz_bookings', 'Group / Party') : $this->I18n->translate($basket, 'Activity.name'),
			$step
		]
	)
);
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<?php echo $this->element('BuzzBookings.bookings_basket', ['data' => $basket]); ?>

<div class="row">
	<div class="col-xs-12">
		<h2><?php echo __d('buzz_bookings', 'Changes & Cancellation'); ?></h2>
		<?php echo $this->I18n->translate(Configure::read('String.bookings_cancellation_intro'), 'value'); ?>
	</div>
</div>

<?php echo $this->Form->create(); ?>
<div class="listing listing--activity listing--booking listing--insurance--yes">

	<?php echo $this->Form->hidden('Booking.is_insured', ['value' => 1]); ?>

	<div class="row">
		<div class="col-xs-12 col-sm-11 col-md-9">
			<?php echo $this->I18n->translate(Configure::read('String.bookings_insurance_option'), 'value'); ?>
		</div>
		<div class="col-xs-12 col-sm-3 col-md-3 text-center">
			<span class="listing__price">
				<h3><?php echo $this->Number->price($insuranceCost); ?></h3>
			</span>
			<div class="clear"></div>
			<?php echo $this->Form->button(__d('buzz_bookings', 'Select'), ['class' => 'button']); ?>
		</div>
	</div>

</div>
<div class="content__spacer"></div>
<?php echo $this->Form->end(); ?>

<?php echo $this->Form->create(); ?>
<div class="listing listing--activity listing--booking listing--insurance--no">

	<?php echo $this->Form->hidden('Booking.is_insured', ['value' => 0]); ?>

	<div class="row">
		<div class="col-xs-12 col-sm-11 col-md-9">
			<?php echo $this->I18n->translate(Configure::read('String.bookings_no_insurance_option'), 'value'); ?>
		</div>
		<div class="col-xs-12 col-sm-3 col-md-3 text-center">
			<span class="listing__price">
				<h3><?php echo $this->Number->price('0.00'); ?></h3>
			</span>
			<div class="clear"></div>
			<?php echo $this->Form->button(__d('buzz_bookings', 'Select'), ['class' => 'button']); ?>
		</div>
	</div>

</div>
<div class="content__spacer"></div>
<?php echo $this->Form->end(); ?>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_bookings', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
		</div>
	</div>
</div>
