<?php
$this->extend('/Common/view');
$this->assign('title', empty($redeemVouchers) ? __d('buzz_bookings', 'Make a Booking') : __d('buzz_bookings', 'Redeem a voucher'));
?>
<h2 class="h3"><?= __d('buzz_bookings', 'Select an Activity') ?></h2>
<?php $totalListedActivites = count($activities); ?>
<div class="row n-items gallery" data-n-items="<?php echo $totalListedActivites; ?>" data-gallery-breakpoints="[1,3,6,6]" style="display:none">
	<?php foreach ($activities as $activity): ?>
		<?php
			$url = ['action' => 'packages', $activity['Activity']['id']];
			if (!empty($redeemVouchers)):
				$url[] = 0;
				$url[] = 1;
			endif;
		?>
		<div class="n-items__item">
			<a class="category category--border<?php
				if (!empty($activity['Activity']['theme_id'])) {
					echo " theme--".$activity['Activity']['theme_id'];
				}
			?>" href="<?php echo $this->Html->url($url); ?>">
				<?php
					$img = (empty($activity['ListingImage'][0])) ? 'no-image.png' : $activity['ListingImage'][0];
					$imgHeight = 250;
					$imgWidth = 360;
					if ($totalListedActivites === 3) {
						$imgHeight = 200;
						$imgWidth = 370;
					}
					if ($totalListedActivites < 3) {
						$imgHeight = 150;
						$imgWidth = 570;
					}
					echo $this->Img->resize($img, ['width' => $imgWidth, 'height' => $imgHeight, 'crop' => true]);
				?>
				<div class="category__content js-match-heights-simple vertical-center">
					<div>
						<h3><?php echo $this->I18n->translate($activity, 'Activity.name'); ?><i class="fa fa-chevron-circle-right fa-inline"></i></h3>
					</div>
				</div>
			</a>
			<div class="content__spacer"></div>
		</div>
	<?php endforeach; ?>
</div>
<?php if ($hasPrivateHirePackages === true): ?>
	<div class="row">
		<div class="col-md-6 col-md-offset-3">
			<div class="outline--secondary background--white padding-gutters-1_2">
				<div class="row">
					<div class="col-xs-12 col-md-6 md-plus-gutterless--right text-center">
						<h3 class="md-plus-left gutter-top"><?php echo __d('buzz_bookings', 'Want Group / Party Booking?'); ?></h3>
					</div>

					<div class="col-xs-12 col-md-6">
						<?php
							echo $this->Fa->link(
								'chevron-circle-right fa-inline',
								__d('buzz_bookings', 'Book Now'),
								['action' => 'private_hire', 0, $redeemVouchers],
								['class' => 'button button--fill md-plus-right']
							);
						?>
					</div>
				</div>
			</div>
			<div class="content__spacer"></div>
		</div>
	</div>
<?php endif; ?>
