<?php

class BookingApiTest extends CakeTestCase {

	public function setUp() {
		parent::setUp();
		$this->BookingApi = ClassRegistry::init('BuzzBookings.BookingApi');
		// We're not directly testing the API as the test data isn't reliable
		// so we want to switch the DB config for test to avoid errors.
		$this->BookingApi->useDbConfig = 'test';
	}

/**
 * Make protected methods accessible for testing
 *
 * @param string $name Method name
 * @return object
 */
	public static function getMethod($name) {
		$BookingApi = new ReflectionClass('BookingApi');
		$method = $BookingApi->getMethod($name);
		$method->setAccessible(true);
		return $method;
	}

/**
 * Test processing of vouchers
 *
 * @return void
 */
	public function testProcessVouchers() {
		// Get sample voucher data
		$data = $this->_apiVoucherResponse();

		$processVouchers = self::getMethod('_processVouchers');
		$result = $processVouchers->invokeArgs($this->BookingApi, [$data['BookingApi']['d']]);
		$this->assertInternalType('array', $result);
		$this->assertEquals(2, count($result[2]['VoucherProvider']['Voucher']));

		return;
	}

	public function testCheckVoucherCode() {
		// Get sample data
		$data = $this->_apiCheckVoucherCodeResponse();

		$processCheckVoucherCode = self::getMethod('_processCheckVoucherCode');
		$result = $processCheckVoucherCode->invokeArgs($this->BookingApi, [$data['BookingApi']['d']]);
		$this->assertInternalType('array', $result);
		$this->assertCount(1, $result['Voucher']['Activity']);

		return;
	}

	public function testProcessDates() {
		// Get sample date/time data
		$data = $this->_apiAvailableDatesResponse();

		$processDates = self::getMethod('_processDates');
		$result = $processDates->invokeArgs($this->BookingApi, [$data['BookingApi']['d']]);
		$this->assertInternalType('array', $result);
		$this->assertEquals(2, count($result[0]['times']));

		return;
	}

/**
 * Sample data from API for testing
 *
 * @return array
 */
	protected function _apiVoucherResponse() {
		return array(
			'BookingApi' => array(
				'd' => array(
					0 => array(
						'__type' => 'VoucherProviderData:#BookingSystem.BookingEngine',
						'VoucherProviderId' => 2,
						'VoucherProviderLogoUrl' => 'http://bodyflight.co.uk/files/uploads/Page/virgin.jpg',
						'VoucherProviderName' => 'Virign experience days',
						'Vouchers' => array(
							0 => array(
								'__type' => 'VoucherProviderVoucherData:#BookingSystem.BookingEngine',
								'BookingTypeId' => 101,
								'IsOffPeakOnly' => false,
								'NumberLocation' => 'located on the bottom right of the voucher.',
								'NumberType' => 'Serial Number',
								'Participants' => 1,
								'Value' => 10,
								'RequiresExpiryDate' => false,
								'RequiresValidation' => false,
								'VoucherDesription' => '',
								'VoucherId' => 9,
								'VoucherName' => 'Introduction to Indoor Surfing for one (FLOWA)'
							),
							1 => array(
								'__type' => 'VoucherProviderVoucherData:#BookingSystem.BookingEngine',
								'BookingTypeId' => 120,
								'IsOffPeakOnly' => false,
								'NumberLocation' => 'located on the bottom right of the voucher.',
								'NumberType' => 'Serial Number',
								'Participants' => 2,
								'Value' => 10,
								'RequiresExpiryDate' => false,
								'RequiresValidation' => false,
								'VoucherDesription' => '',
								'VoucherId' => 11,
								'VoucherName' => 'Introduction to Indoor Surfing for two (FLOWZ)'
							),
						)
					),
					1 => array(
						'__type' => 'VoucherProviderData:#BookingSystem.BookingEngine',
						'VoucherProviderId' => 3,
						'VoucherProviderLogoUrl' => 'http://bodyflight.co.uk/files/uploads/Page/lastminute.jpg',
						'VoucherProviderName' => 'Lastminute.com',
						'Vouchers' => array(
							0 => array(
								'__type' => 'VoucherProviderVoucherData:#BookingSystem.BookingEngine',
								'BookingTypeId' => 101,
								'IsOffPeakOnly' => false,
								'NumberLocation' => 'located on the bottom right of the voucher.',
								'NumberType' => 'Serial Number',
								'Participants' => 1,
								'Value' => 10,
								'RequiresExpiryDate' => false,
								'RequiresValidation' => false,
								'VoucherDesription' => '',
								'VoucherId' => 15,
								'VoucherName' => 'Introduction to Indoor Surfing for one (FLOWA)'
							)
						)
					),
					2 => array(
						'__type' => 'VoucherProviderData:#BookingSystem.BookingEngine',
						'VoucherProviderId' => 8,
						'VoucherProviderLogoUrl' => 'http://bodyflight.co.uk/files/uploads/Page/flowhouse.jpg',
						'VoucherProviderName' => 'Bodyflight',
						'Vouchers' => array()
					)
				)
			)
		);
	}

	protected function _apiCheckVoucherCodeResponse() {
		return array(
			'BookingApi' => array(
				'd' => array(
					'__type' => 'CheckVoucherData:#BookingSystem.BookingEngine',
					'Activities' => array(
						array(
							'__type' => 'VoucherActivity:#BookingSystem.BookingEngine',
							'ActivityId' => '0',
							'BookingTypeId' => '10',
							'RequiredQuantity' => '1'
						)
					),
					'FailureDescription' => null,
					'Participants' => 2,
					'Status' => 'Ok',
					'VoucherDescription' => 'Fly With A Friend',
					'Cost' => 10
				)
			)
		);
	}

	protected function _apiAvailableDatesResponse() {
		$date = date('d/m/Y', strtotime('+1 day'));
		// We need to make sure the test res[]
		return array(
			'BookingApi' => array(
				'd' => array(
					0 => array(
						'__type' => 'DateData:#BookingSystem.BookingEngine',
						'Date' => $date,
						'Itineraries' => array(
							0 => array(
								0 => array(
									'__type' => 'BookingTypeData:#BookingSystem.BookingEngine',
									'ActivityId' => 0,
									'BookingTypeId' => 1,
									'CheckInMins' => 60,
									'Description' => '2 Flight Experience',
									'ExperienceId' => 0,
									'FromTime' => '12:00',
									'IsPeak' => false,
									'SiteId' => 1,
									'ToTime' => '12:29'
								)
							),
							1 => array(
								0 => array(
									'__type' => 'BookingTypeData:#BookingSystem.BookingEngine',
									'ActivityId' => 0,
									'BookingTypeId' => 1,
									'CheckInMins' => 60,
									'Description' => '2 Flight Experience',
									'ExperienceId' => 0,
									'FromTime' => '14:00',
									'IsPeak' => false,
									'SiteId' => 1,
									'ToTime' => '14:59'
								)
							)
						)
					)
				)
			)
		);
	}

}
