<?php

App::uses('BuzzBookingsAppController', 'BuzzBookings.Controller');

class ExtrasController extends BuzzBookingsAppController {

/**
 * Admin form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['UpsellApplicableActivity.UpsellApplicableActivity']['label'] = __d('buzz_bookings', 'Upsell Applicable Activities');
		$fields['UpsellApplicableActivity.UpsellApplicableActivity']['type'] = 'multicheck';
		$fields['UpsellExclusion.UpsellExclusion']['label'] = __d('buzz_bookings', 'Upsell Exclude Packages');
		$fields['UpsellExclusion.UpsellExclusion']['type'] = 'multicheck';

		return $fields;
	}

/**
 * Populate admin lookups
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$Extra = $this->{$this->modelClass};

		$this->set('upsellApplicableActivities', $Extra->UpsellApplicableActivity->listNonMultiExperienceActivities());

		// Exclude private hire and multi-experience packages.
		$conditions = [
			'UpsellExclusion.participants >' => 0,
			'UpsellExclusion.api_reference NOT LIKE' => '%,%'
		];
		$this->set('upsellExclusions', $Extra->UpsellExclusion->find('list', compact('conditions')));

		return;
	}

}
