<?php

App::uses('BuzzBookingsAppController', 'BuzzBookings.Controller');

class ActivityPackagesController extends BuzzBookingsAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name',
				'description'
			)
		)
	);

	public function admin_edit($id = null) {
		parent::admin_edit($id);

		$ActivityPackage = $this->{$this->modelClass};
		// Exclude private hire and multi-experience packages.
		$conditions = [
			'ActivityPackage.participants >' => 0,
			'ActivityPackage.api_reference NOT LIKE' => '%,%'
		];
		if ($id !== null) {
			$conditions['ActivityPackage.id <>'] = $id;
		}
		$this->set('upsellExclusions', $ActivityPackage->find('list', compact('conditions')));

		$this->Translation->adminTranslationFormFields();
		$this->set('upsellFields', $this->_adminFormUpsellFields());
		$this->view = 'BuzzBookings./ActivityPackages/admin_form';

		return;
	}

	protected function _adminFormUpsellFields() {
		return array(
			'UpsellApplicableActivity.UpsellApplicableActivity' => array(
				'label' => __d('buzz_bookings', 'Upsell Applicable Activities'),
				'type' => 'multicheck',
				'before' => '<p class="input__help">' . __d('buzz_bookings', 'Tick which activities you want to upsell this package on:') . '</p>'
			),
			'UpsellExclusion.UpsellExclusion' => array(
				'label' => __d('buzz_bookings', 'Upsell Exclude Packages'),
				'type' => 'multicheck',
				'before' => '<p class="input__help">' . __d('buzz_bookings', 'Tick which other packages you <em>do not</em> want to upsell this package on:') . '</p>'
			)
		);
	}

	/**
	 * Admin form fields
	 *
	 * @return array
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['ActivityPackage.participants']['type'] = 'select';

		$fields['ActivityPackage.api_reference']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'Used for checking availability in the diary.') . '</p>';

		$fields['ActivityPackage.api_additional_notes']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'Passed to the API when completing a booking.') . '</p>';

		$fields['ActivityPackage.email_notifications']['type'] = 'string';
		$fields['ActivityPackage.email_notifications']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'Enter any email addresses (comma separated) you would like to be notified when someone purchases this package.') . '</p>';

		$fields['ActivityPackage.use_all_discount_codes']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'When ticked, any discount code can be used without restriction. Alternatively you can leave this unticked, and enter specific discount codes below.') . '</p>';

		$fields['ActivityPackage.valid_discount_codes']['type'] = 'string';
		$fields['ActivityPackage.valid_discount_codes']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'Enter specific discount codes to allow, comma separated.') . '</p>';

		$fields['ActivityPackage.off_peak_discounts_only']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'When ticked, any discount code above (or from the list of all if you have selected that option) will only apply during off-peak times.') . '</p>';

		return $fields;
	}

	/**
	 * Populate admin lookups
	 *
	 * @return void
	 */
	protected function _adminPopulateLookups() {
		$ActivityPackage = $this->{$this->modelClass};

		$activities = $ActivityPackage->Activity->find('list');
		$upsellApplicableActivities = $activities;
		if ($ActivityPackage->Activity->getMultiExperience()) {
			// Remove the multi-experience activity from upsell applicable
			// activities as there can't be any bookable upsells for
			// multi-experience bookings.
			unset($upsellApplicableActivities[$ActivityPackage->Activity->getMultiExperience()]);
		}
		$this->set(compact('activities', 'upsellApplicableActivities'));

		$participants = array_combine(range(1, 12), range(1, 12));
		array_unshift($participants, __d('buzz_bookings', 'Group / Party Booking'));
		$this->set(compact('participants'));

		return;
	}

	/**
	 * Admin index paginate
	 *
	 * @return array
	 */
	protected function _adminIndexPaginate() {
		$conditions = $this->_processFilter();

		$paginate = array(
			'conditions' => $conditions,
			'contain' => array(
				'Activity'
			)
		);

		return $paginate;
	}

	/**
	 * Admin index columns
	 *
	 * @return array
	 */
	protected function _adminIndexColumns() {
		$ActivityPackage = $this->{$this->modelClass};

		$columns = parent::_adminIndexColumns();

		$newColumns = array(
			'Activity.name' => array(
				'label' => __d('buzz_bookings', 'Activity'),
				'type' => 'string'
			)
		);

		return ArrayUtil::addAfter($columns, 'ActivityPackage.name', $newColumns);
	}

	/**
	 * Filters
	 *
	 * @return array
	 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		unset($filters['Booking.name']);
		unset($filters['Booking.created']);
		unset($filters['Booking.modified']);

		$newFilters = array(
			'ActivityPackage.activity_id' => array(
				'label' => __d('buzz_bookings', 'Activity'),
				'type' => 'select',
				'compare' => array('ActivityPackage.activity_id' => "%s")
			)
		);

		return ArrayUtil::addAfter($filters, 'Booking.sales_ref', $newFilters);
	}

}
