<?php
class BuzzBookingsAddedInsuranceColumns extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzBookings_added_insurance_columns';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'bookings' => array(
					'is_insured' => array('type' => 'boolean', 'null' => false, 'default' => '0', 'after' => 'booking_date'),
					'insurance_cost' => array('type' => 'decimal', 'null' => true, 'default' => '0.00', 'length' => '10,2', 'unsigned' => false, 'after' => 'is_insured'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'bookings' => array('is_insured', 'insurance_cost'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$data = [
				[
					'name' => 'bookings_cancellation_intro',
					'label' => 'Changes & Cancellation Text',
					'value' => '<p><strong>Important Note:</strong> To change or cancel this booking you will need to provide at least 72 hours notice prior to your selected booking time.</p><p>All bookings are Non-Refundable.</p>'
				],
				[
					'name' => 'bookings_insurance_option',
					'label' => 'Bookings Insurance Option',
					'value' => '<p>Add \'ANY REASON\' protection to enable me to rebook without notice. This protects against - sickness, traffic, forgotten weddings or any reason we can\'t make it on the day!</p>'
				],
				[
					'name' => 'bookings_no_insurance_option',
					'label' => 'Bookings No Insurance Option',
					'value' => '<p>I understand 72 hours notice is required to move or cancel this booking. With less than this notice I will lose my booking.</p>'
				]
			];
			ClassRegistry::init('SiteSettings.CmsString')->saveMany($data);
		}
		return true;
	}
}
