<?php
	// define blog post url
	$blogPostUrl = $this->Route->getItemRoute('BuzzBlog', 'BlogPost');
	$blogPostUrl['action'] = 'view';
	$blogPostUrl[] = $blog['BlogPost']['id'];
?>
<div class="listing listing--booking">
	<div class="row">
		<div class="col-xs-12 col-sm-4 col-xs-3">
			<?php
				$imgAlt = (! empty($blog['ListingImage'][0]['alt'])) ? $blog['ListingImage'][0]['alt'] : $blog['BlogPost']['name'];
				$image = ! empty($blog['ListingImage'][0]) ? $blog['ListingImage'][0] : [];
				echo $this->Img->resize($image, [
					'width' => 670,
					'height' => 510,
					'crop' => true
				], [
					'alt' => $imgAlt,
					'url' => $blogPostUrl,
					'class' => 'full'
				]);
			?>
		</div>
		<div class="col-xs-12 col-sm-8 col-xs-9">
			<div class="buzz-blog__list__item__date">
				<small><?= $this->Time->i18nFormat($blog['BlogPost']['posted'], '%e %B %Y') ?></small>
			</div>
			<h2 class="buzz-blog__list__item__title">
				<?php echo $this->Html->link($blog['BlogPost']['name'], $blogPostUrl); ?>
			</h2>

			<div class="buzz-blog__list__item__snippet">
				<p><?= stripslashes($blog['BlogPost']['snippet']) ?></p>
				<?= $this->Fa->link('chevron-circle-right', __d('buzz_blog', 'Read More'), $blogPostUrl, ['class' => 'button background--nonary']) ?>
			</div>
		</div>
	</div>
</div>
<div class="content__spacer"></div>
