<?php if (isset($this->request->data['BlogComment']) && ! empty($this->request->data['BlogComment'])): ?>

	<div class="comments_container">

		<?php foreach ($this->request->data['BlogComment'] as $comment): ?>

			<div class="comment">

				<div class="pull-right">
				<?php
					echo $this->Html->link(
						'Edit',
						array(
							'admin' => true,
							'plugin' => 'buzz_blog',
							'controller' => 'blog_comments',
							'action' => 'edit',
							$comment['id']
						),
						array(
							'class' => 'btn btn-sm'
						)
					);
					echo '&nbsp;';
					echo $this->Html->link(
						'Delete',
						array(
							'admin' => true,
							'plugin' => 'buzz_blog',
							'controller' => 'blog_comments',
							'action' => 'delete',
							$comment['id'],
						),
						array(
							'class' => 'btn btn-sm btn-danger',
							'confirm' => 'Are you sure you wish to delete this comment?'
						)
					);
				?>
				</div>

				<h3><?php echo $comment['author']; ?></h3>
				<h5><?php echo $this->Time->format('F jS, Y \a\t H:i', $comment['created']); ?></h5>

				<?php echo $comment['comment']; ?>
			</div>

		<?php endforeach; ?>

	</div>

<?php endif; ?>
