<?php
$this->extend('/Common/2col');
$this->assign('title', $this->I18n->translate($page, 'Page.title'));
$this->start('side');
?>
<?= $this->element('BuzzBlog.sidebar') ?>
<?php $this->end(); // side ?>

<div class="buzz-blog__post">

    <div class="buzz-blog__post__published">
		<small><?= $this->Time->i18nFormat($data['BlogPost']['posted'], '%e %B %Y') ?></small>
    </div>

    <h1><?= h($data['BlogPost']['name']) ?></h1>

    <?= $this->Blog->injectAtFirstBreak($data['BlogPost']['body'], $this->element('BuzzBlog.gallery')) ?>

    <div class="video">
    	<?= $this->Video->embed($data['BlogPost']['video_url'], ['width' => '100%']) ?>
    </div>

    <?php if (isset($data['BlogTag']) && ! empty($data['BlogTag'])): ?>
        <p class="buzz-blog__post__tags">
            <span>Tags:</span>
            <?php
            $tags = array();

            foreach ($data['BlogTag'] as $tag) {

                $tagUrl = RouterUtil::getItemRoute('BuzzBlog', 'BlogTag');
                $tagUrl[] = $tag['tag'];

                $tags[] = $this->Html->link($tag['tag'], $tagUrl);
            }

            echo implode(', ', $tags);
            ?>
        </p>
    <?php endif; ?>

    <?php if (Configure::check('BuzzBlog.add_this')): ?>
		<div class="addthis_inline_share_toolbox"></div>
	<?php endif; ?>

    <?php if (Configure::read('BuzzBlog.disable_comments') != true): ?>
        <div class="buzz-blog__comments">
            <?php $commentCount = count($data['BlogComment']); ?>

            <a name="blog-comments"></a>

            <h2>
            	<?= $commentCount > 0 ? __dn('buzz_blog', '1 Comment', '%d Comments') : __d('buzz_blog', 'No Comments') ?>
            </h2>

            <?php if ($commentCount > 0): ?>

                <div class="buzz-blog__comments__container">
                    <?php foreach ($data['BlogComment'] as $comment): ?>

                        <div class="buzz-blog__comments__comment">
                            <a name="comment-<?= $comment['id']; ?>"></a>

                            <div class="buzz-blog__comments__comment__image">
                                <?php
                                echo $this->Gravatar->get_gravatar(
                                    $comment['email'],
                                    58,
                                    'mm',
                                    'g',
                                    true,
                                    array(
                                        'alt' => h($comment['author']) . ' Gravatar'
                                    )
                                );
                                ?>
                            </div>

                            <div class="buzz-blog__comments__comment__body">
                                <?php
                                echo '<span class="buzz-blog__comments__comment__author">' . $comment['author'] . '</h2>';
                                echo '<span class="buzz-blog__comments__comment__published">' . $this->Time->format('F jS, Y \a\t H:i', $comment['created']) . '</h4>';
                                echo $comment['comment'];
                                ?>
                            </div>

                        </div>

                    <?php endforeach; ?>
                </div>

            <?php else: ?>
                <p><?= __d('buzz_blog', 'Be the first to comment!') ?></p>
            <?php endif; ?>

            <?= $this->element('comments-form'); ?>
        </div>
    <?php endif; ?>
</div>
<?php if (Configure::check('BuzzBlog.add_this')): ?>
	<?php $this->start('script'); ?>
		<?= $this->Html->script([Configure::read('BuzzBlog.add_this')]) ?>
	<?php $this->end(); ?>
<?php endif; ?>
