<?php

foreach ($posts as $post) {

	$postTime = strtotime($post['BlogPost']['created']);

	$postLink = $this->Route->getItemRoute('BuzzBlog', 'BlogPost');
	$postLink['action'] = 'view';
	$postLink[] = $post['BlogPost']['id'];

	// Remove & escape any HTML to make sure the feed content will validate.
	$bodyText = h(strip_tags($post['BlogPost']['body']));
	$bodyText = $this->Text->truncate($bodyText, 400, array(
		'ending' => '...',
		'exact'  => true,
		'html'   => true,
	));

	echo  $this->Rss->item(array(), array(
		'title' => $post['BlogPost']['name'],
		'link' => $postLink,
		'guid' => array('url' => $postLink, 'isPermaLink' => 'true'),
		'description' => $bodyText,
		'pubDate' => $post['BlogPost']['created']
	));

}
