BuzzBlog
========

Simple blog plugin for use on sites with categories, comments, tags and obviously posts.


FEATURES
---------

Blog Posts

- author
- title
- body
- publish date
- snippet (auto created)

Blog Categories

- There is also an 'Uncategorised' label for posts with no category

Blog Comments

- Comment management, edit / delete, is also available from within each posts edit page
- Comments use Gravatar for pictures
- Anchors available if copied across from default template.
- Admin email notification on new comment

Blog Tags

- Tag listing page for related posts.

Blog Archive (by date)

Sidebar widgets

- Latest posts
- Categories list (with no. posts)
- Monthly Archive (with no. posts)

RSS feed


REQUIREMENTS
-------------

First you'll need to make sure you have the copy of Core that has plugins support in the routable plugin. (Depending if you are adding this to an old cake site, it may not have support for it).

Easy check is to open `app/Plugin/Routable/Model/Behavior/RoutableBehavior.php` and search for this line "`$path = str_replace(':plugin', $pluginPath, $path);`" around `line 178`. It should be within the `_replacePathToken()` function. If you don't have that line, you'll need to upgrade routable plugin to the latest one from core.


INSTALLATION
-------------

1) From the root directory of your project run `composer require evoluted/blog:"2.4.1.*"` where the `2.4.1.*` indicates the latest version found in the "tags" tab above. The asterisk on the last number indicates that you want any bug fixes that may occur in the future.

2) Add the following code to the `app/Config/bootstrap.php` plugin load array.

	'EvBlog' => array(
		'bootstrap' => true,
		'routes' => true
	)

3) Run the migrations command to populate your database:

	Console/cake Migrations.migration run all --plugin EvBlog

4) Add links to admin menu, urls are as follows:

- /admin/buzz_blog/blog_posts
- /admin/buzz_blog/blog_categories

5) From here you are good to go (some extra config is available.)

6) The plugin has been setup using the standard bootstrap file and code found on the dev wiki. Meaning you can override some config options by placing a config file in the following location: app/Config/Plugin/buzz_blog.php
Available options are:
'page_id' - Allows you to set a content page id for title / description / meta information (default value is null)
'snippet_length' - Allows you to set the snippet length used on listing pages. (default value is 85 characters)

Use the following code in the file mentioned at the beginning of point 6, to override any of the options.
<?php

$config = array(
	'EvBlog' => array(
		'page_id' => 16, //Set a page ID here to add content to the top of the blog index page
		'snippet_length' => 70
	)
);


URLS
-----

Default urls for the blog are also follows:

- /blog/ 									- Main blog index
- /blog/{slug-name} 						- Blog view page
- /blog/{slug-name}#blog-comments 			- Blog view page but anchor to the comments section if long post
- /blog/{slug-name}#comment-{comment-id} 	- Blog view page but anchor to specific comment
- /blog-archives/{YYYY-MM-DD} 				- Blog archive listing for posts published in that month (DD will be the last day of the given month)
- /blog-category/{slug-name}				- Blog category listing for posts tagged to that category
- /blog-tags/{tag} 							- Blog tag listing for posts with the given tag
- /blog/index.rss 							- Blog RSS Feed


Obviously when required, it's preferrable to use the router array format rather then the exact url.

	array(
		'plugin' => 'buzz_blog',
		'controller' => blog_posts',
		'action' => 'index'
	);

	array(
		'plugin' => 'buzz_blog',
		'controller' => blog_posts',
		'action' => 'archives',
		{DATE}
	);

	array(
		'plugin' => 'buzz_blog',
		'controller' => blog_posts',
		'action' => 'view',
		{POST_ID}
	);

	array(
		'plugin' => 'buzz_blog',
		'controller' => blog_categories',
		'action' => 'view',
		{CATEGORY_ID}
	);

	array(
		'plugin' => 'buzz_blog',
		'controller' => blog_tags',
		'action' => 'view',
		{TAG}
	);

Disabling Comments
------------------
To completely disable the blog comment system, see the config file. You can set the `disable_comments` flag to `true`. When set it will automatically remove comment forms from the base view files, as well as from the admin area.

Disabling Post Author
----
To stop the author field from displaying on the Blog Post admin edit form and in the Blog Post admin filter fields a flag of `disable_post_author` can be set to `true` within the app version of the EvBlog plugin configuration file.

Disabling Tags
----
To disable tags in the plugin you can update the config file, much like when disabling comments. Adding `disable_tags` to the app based EvBlog configuration file and setting the flag to `true` will prevent the tags element from showing on the Blog Posts admin form, thus prevent the rest of the Blog Tags functionality from firing in the rest of the plugin.

Disabling Categories
----
A flag for disabling categories can be set in the config file. Add `disable_categories` with a value of `true` and this will hide the category column and category form field in the admin.

Widgets
----

Three widgets are available in the plugin to simplify displaying details of posts across your website. There are widgets available to display latest blog posts, blog post categories and blog post archives. Blog post categories and blog post archives also display a tally of active blog posts next to each listing item.

To display any of the three widgets simply use one of the following CakePHP variables on your template; `evBlogWidgetLatestposts`, `evBlogWidgetCategories` or `evBlogWidgetArchives`.


Future Functionality
-------

Comment replies, a 'parent_id' field is present in the comments table but due to time issues this wasn't actually included in first release.

Remove deprecated, none coding standards, versions of the sidebar widget variable assignments found in `BlogWidgetComponent`.

