<?php
App::uses('BuzzBlogAppModel', 'BuzzBlog.Model');

class BlogComment extends BuzzBlogAppModel
{
	public $displayField = 'author';

	public $belongsTo = array(
		'BlogPost' => array(
			'className' => 'BuzzBlog.BlogPost'
		)
	);

	public $validate = array(
		'blog_post_id' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please tag to a blog post'
			),
		),
		'author' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please add an author'
			),
		),
		'comment' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please add a comment'
			),
		)
	);

}
