<?php
App::uses('BuzzBlogAppModel', 'BuzzBlog.Model');

class BlogCategory extends BuzzBlogAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'alias' => 'blog-category/:displayField/*',
			'config' => 'BuzzBlog'
		),
		'MetaData.Meta'
	);

	public $displayField = 'name';

	public $hasAndBelongsToMany = array(
		'BlogPost' => array(
			'className' => 'BuzzBlog.BlogPost',
			'joinTable' => 'buzz_blog_blog_categories_blog_posts'
		)
	);

	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please add a name'
			),
		)
	);


}
