<?php
App::uses('BuzzBlogAppController', 'BuzzBlog.Controller');
App::uses('CustomEmail', 'Lib');

class BlogCommentsController extends BuzzBlogAppController {

	public function beforeFilter() {
		$this->Auth->allow('post_comment');

		return parent::beforeFilter();
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		unset($fields['BlogComment.blog_post_id'], $fields['BlogComment.parent_id']);
		$fields['BlogComment.comment']['type'] = 'text_plain';
		$fields['BlogComment.comment']['style'] = 'width: 360px;height:150px;';

		return $fields;
	}

	public function admin_delete($id) {
		$Model = $this->{$this->modelClass};

		$data = $Model->findById($id);

		$Model->delete($id);

		$this->Session->setFlash(array(
			'title' => 'Comment deleted',
			'description' => 'Comment has been successfully deleted!'
		), 'flash_success');

		$route = RouterUtil::getItemRoute('BuzzBlog', 'BlogPost');
		$route['action'] = 'edit';
		$route['admin'] = true;
		$route[] = $data['BlogComment']['blog_post_id'];

		return $this->redirect($route);
	}

	public function admin_edit($id = null) {
		$Model = $this->{$this->modelClass};

		$data = $Model->find('first', array(
			'conditions' => array(
				'BlogComment.id' => $id
			),
			'contain' => array('BlogPost')
		));

		$route = RouterUtil::getItemRoute('BuzzBlog', 'BlogPost');
		$route['action'] = 'edit';
		$route['admin'] = true;
		$route[] = $data['BlogComment']['blog_post_id'];

		$this->adminRedirect = $route;
		$this->set('blogPost', $data['BlogPost']);

		parent::admin_edit($id);


		$this->view = 'admin_edit';
	}

	public function post_comment() {
		if ($this->request->is('post') && ! empty($this->request->data)) {

			$Model = $this->{$this->modelClass};

			if (isset($this->request->data['BlogComment']['email_confirm']) && ! empty($this->request->data['BlogComment']['email_confirm'])) {

				// spam field was field in, redirect them to the login page, will display success message
				$this->Session->setFlash(
					'Comment has been posted.',
					'BuzzBlog.message',
					array('class' => 'buzz-blog__message--success'),
					'blog-comment'
				);

			} else {

				if (! isset($this->request->data['BlogComment']['parent_id']) || empty($this->request->data['BlogComment']['parent_id'])) {

					$this->request->data['BlogComment']['parent_id'] = null;
				}

				if (isset($this->request->data['BlogComment']['comment_id']) && empty($this->request->data['BlogComment']['comment_id'])) {

					$moderated = false;

					// Check to see if we're moderating comments.
					if (Configure::read('SiteSetting.Blog.comment_moderation') == '1') {
						$this->request->data['BlogComment']['is_active'] = 0;
						$moderated = true;
					} elseif (Configure::read('SiteSetting.comment_moderation') == '1') {
						// Fallback for older sites that use older copies of EvSiteSettings.
						$this->request->data['BlogComment']['is_active'] = 0;
						$moderated = true;
					} else {
						$this->request->data['BlogComment']['is_active'] = 1;
					}

					if ($Model->saveAll($this->request->data)) {

						if (!$this->request->data['BlogComment']['is_active']) {
							$this->Session->setFlash(
								'Thank you. Your comment is awaiting approval and will appear here once it has been reviewed.',
								'BuzzBlog.message',
								array('class' => 'buzz-blog__message--success'),
								'blog-comment'
							);
						} else {
							$this->Session->setFlash(
								'Thanks, your comment has been posted!',
								'BuzzBlog.message',
								array('class' => 'buzz-blog__message--success'),
								'blog-comment'
							);
						}

						$post = $Model->BlogPost->findById($this->request->data['BlogComment']['blog_post_id']);

						// send email to admin informing of new comment
						$email = new CustomEmail('sendgrid');

						$email->theme('Site');
						$email->template('BuzzBlog.new-comment');
						$email->emailFormat('html');
						$email->to(Configure::read('SiteSetting.general.admin_email'));
						$email->from(array(Configure::read('SiteSetting.general.admin_email') => Configure::read('SiteSetting.general.site_title')));
						$email->subject('New blog comment posted');
						$email->viewVars(array(
							'post' => $post,
							'comment' => $this->request->data,
							'comment_id' => $Model->id,
							'moderated' => $moderated
						));
						$email->helpers(array(
								'Html',
								'Routable.Route'
						));
						$email->send();

					} else {

						$this->Session->setFlash(
							'There was an error posting your comment, please try again.',
							'BuzzBlog.message',
							array('class' => 'buzz-blog__message--error'),
							'blog-comment'
						);
					}
				}
			}
		}

		$this->redirect(
			$this->referer() . '#blog-comments'
		);
	}
}
