<?php

$config = array(
	'BuzzBlog' => array(
		'page_id' => null, //Set a page ID here to add content to the top of the blog index page
		'snippet_length' => 85, // number of characters to show in the snippet
		'listing_limit' => 10, // number of posts to show on the blog listing
		'rss_limit' => 20, // number of posts to show on the blog rss listing
		'disable_comments' => false,
		'disable_tags' => false,
		'disable_post_author' => false,
		'disable_categories' => false,
		'route' => array(
			'BlogPost' => array(
				'controller' => 'buzz_blog.blog_posts', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'buzz_blog' // used for model references
			),
			'BlogCategory' => array(
				'controller' => 'buzz_blog.blog_categories', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'buzz_blog' // used for model references
			),
			'BlogTag' => array(
				'controller' => 'buzz_blog.blog_tags', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'buzz_blog' // used for model references
			),
			'BlogComment' => array(
				'controller' => 'buzz_blog.blog_comments', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'buzz_blog' // used for model references
			),
		),
		// Pass the script for Add This,
		// e.g. '//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-591ef47489d1327e'
		'add_this' => null
	)
);
