<?php

class AdvertHelper extends AppHelper {

/**
 * Element renderer for advert templates.
 *
 * @param array $advert
 * @param array $options
 * @return string
 */
	public function render($advert, array $options = []) {
		$template = $advert['view_template'] ?: $advert['AdvertTemplate']['view_template'];
		list($plugin, $template) = pluginSplit($template);
		$element = 'Adverts' . DS . $template;
		if (!empty($plugin)) {
			$element = $plugin . '.' . $element;
		}
		if ($this->_View->elementExists($element)) {
			return $this->_View->element($element, ['data' => $advert], $options);
		}
	}

}
