<?php

App::uses('ModelBehavior', 'Behavior');

class AdvertHostBehavior extends ModelBehavior {

/**
 * Setup behavior
 *
 * @param Model $Model
 * @param array $settings
 * @return void
 */
	public function setup(Model $Model, $settings = array()) {
		parent::setup($Model, $settings);
		$this->settings[$Model->alias] = array_merge($settings);

		$Model->hasMany['AdvertRelation'] = array(
			'className' => 'BuzzAdverts.AdvertRelation',
			'foreignKey' => 'foreign_id',
			'conditions' => array(
				'AdvertRelation.model' => $Model->alias
			),
			'dependent' => true,
			'cascade' => true
		);

		$Model->hasAndBelongsToMany['Advert'] = array(
			'className' => 'BuzzAdverts.Advert',
			'joinTable' => 'advert_relations',
			'with' => 'AdvertRelation',
			'foreignKey' => 'foreign_id',
			'associationForeignKey' => 'advert_id',
			'conditions' => array(
				'AdvertRelation.model' => $Model->alias
			),
			'unique' => 'keepExisting'
		);

		return;
	}

/**
 * Before validate
 *
 * @param Model $Model
 * @param array $options
 * @return bool
 */
	public function beforeValidate(Model $Model, $options = []) {
		if (parent::beforeValidate($Model, $options) === true) {

			$id = $Model->id ?: null;
			$id = !empty($Model->data[$Model->alias]['id']) ? $Model->data[$Model->alias]['id'] : $id;

			if (isset($Model->data['Advert']) && $id !== null) {

				$adverts = $Model->data['Advert']['Advert'];
				unset($Model->data['Advert']);

				// Retrieve the existing relations.
				$relations = $Model->AdvertRelation->find(
					'all',
					array(
						'conditions' => array(
							'model' => $Model->alias,
							'foreign_id' => $id
						)
					)
				);
				$relationKeys = Hash::combine($relations, '{n}.AdvertRelation.advert_id', '{n}.AdvertRelation.id');

				if (is_array($adverts)) {
					// Build up the save data for related adverts.
					foreach ($adverts as $advertId) {
						$Model->data['AdvertRelation'][] = array(
							'id' => !empty($relationKeys[$advertId]) ? $relationKeys[$advertId] : null,
							'model' => $Model->alias,
							'advert_id' => $advertId
						);
					}
				} else {
					$adverts = [];
				}

				// Remove related adverts (everything must have passed
				// validation up to this point).
				$conditions = [
					'advert_id' => array_diff(Hash::extract($relations, '{n}.AdvertRelation.advert_id'), $adverts),
					'model' => $Model->alias,
					'foreign_id' => $id
				];
				$Model->AdvertRelation->deleteAll($conditions, false);

			}

			return true;

		}
		return false;
	}

}
