<?php

App::uses('BuzzAdvertsAppModel', 'BuzzAdverts.Model');

class AdvertTemplate extends BuzzAdvertsAppModel {

	public $hasOne = array(
		'AdvertRelation' => array(
			'className' => 'BuzzAdverts.AdvertRelation'
		)
	);

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'view_template' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		)
	);

/**
 * After find.
 *
 * @param array $results
 * @param bool $primary
 * @return array
 */
	public function afterFind($results, $primary = false) {
		$templates = [];

		// Check the adverts being loaded and get any required variables (this
		// is to handle special cases like Buy Gift Vouchers).
		if ($primary === false) {
			foreach ($results as $key => $val) {
				if (!empty($val['AdvertTemplate']['view_template'])) {
					list($plugin, $template) = pluginSplit($val['AdvertTemplate']['view_template']);
					$templates[$key] = $template;
				}
			}

			if (false !== $key = array_search('buy_gift_vouchers', $templates)) {
				$voucherActivities = ClassRegistry::init('BuzzVouchers.VoucherActivity')->listListed();
				$results[$key] = Hash::insert($results[$key], 'AdvertTemplate.vars.voucherActivities', $voucherActivities);
			}
		}

		return $results;
	}

}
