<?php

App::uses('Component', 'Controller');

class AdvertsComponent extends Component {

/**
 * Controller, set in self::initialize().
 *
 * @var Controller
 */
	protected $_controller = null;

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->_controller = $controller;
	}

	public function setupAdvertAdminFields() {
		$this->_controller->loadModel('BuzzAdverts.Advert');
		$adverts = $this->_controller->Advert->find('list', ['conditions' => ['is_global' => false]]);

		$advertFields = [
			'Advert.Advert' => [
				'type' => 'multicheck',
				'label' => __d('buzz_adverts', 'Adverts')
			]
		];

		$this->_controller->set(compact('adverts', 'advertFields'));

		return;
	}

}
