<?php

App::uses('BuzzAdvertsAppController', 'BuzzAdverts.Controller');

class AdvertsController extends BuzzAdvertsAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'heading_text',
				'subheading_text',
				'link_text',
				'url' => array(
					'label' => 'URL'
				)
			)
		)
	);

	protected function _adminIndexPaginate() {
		$paginate = parent::_adminIndexPaginate();

		if ($this->Auth->user('UserGroup.id') > 1) {
			// Prevent client from viewing system adverts (these need manually
			// creating as require the creation of a new View template).
			$paginate['conditions']['or'] = array(
				'Advert.view_template IS NULL',
				'Advert.view_template' => ''
			);
		}

		return $paginate;
	}

	/**
	 * Form fields
	 *
	 * @return array
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		if ($this->Auth->user('UserGroup.id') > 1) {
			unset($fields['Advert.system_name']);
			unset($fields['Advert.view_template']);
			unset($fields['Advert.is_global']);
		}

		$fields['Advert.url']['label'] = __d('buzz_adverts', 'URL');

		$fields['Advert.advert_template_id']['after'] = ' <a href="' . Router::url(['controller' => 'advert_templates', 'action' => 'examples', 'admin' => false]) . '" target="_blank">' . __d('buzz_adverts', 'Examples') . '</a>';

		return $fields;
	}

	/**
	 * Admin add/edit form
	 *
	 * @param int $id
	 * @return void
	 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		if (!empty($this->request->data['Advert']['view_template']) && $this->Auth->user('UserGroup.id') > 1) {
			// Prevent normal admin users from editing adverts with defined
			// view_templates. These are special cases.
			throw new UnauthorizedException();
		}

		$this->Translation->adminTranslationFormFields();
		$this->view = 'BuzzAdverts.admin_form';

		return;
	}

	/**
	 * Defines a whitelist of columns to be displayed on the admin index.
	 *
	 * @return array whitelisted columns
	 */
	protected function _adminIndexColumnsWhitelist() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumnsWhitelist();

		if ((int)$this->Auth->user('UserGroup.id') === 1) {
			$columns[] = $modelAlias . '.view_template';
		}

		return $columns;
	}

	protected function _adminPopulateLookups() {
		$Advert = $this->{$this->modelClass};

		$templates = $Advert->AdvertTemplate->find('all');
		foreach ($templates as $template) {
			$advertTemplates[] = array(
				'value' => $template['AdvertTemplate']['id'],
				'name' => $template['AdvertTemplate']['name'],
				'data-fields' => $template['AdvertTemplate']['fields'],
				'data-themeable' => (int)$template['AdvertTemplate']['is_themeable']
			);
		}
		$themes = $Advert->Theme->find('list');

		$this->set(compact('advertTemplates', 'themes'));

		return;
	}

}
