<?php

App::uses('BuzzAdvertsAppController', 'BuzzAdverts.Controller');

class AdvertTemplatesController extends BuzzAdvertsAppController {

	/**
	 * Display example adverts (admin only).
	 *
	 * @return void
	 */
	public function examples() {
		$AdvertTemplate = $this->{$this->modelClass};

		$data = $AdvertTemplate->find('all');
		$sample = [
			'heading_text' => __d('buzz_adverts', 'Heading Text'),
			'subheading_text' => __d('buzz_adverts', 'Subheading Text'),
			'link_text' => __d('buzz_adverts', 'Link Text'),
			'url' => '#',
			'view_template' => null,
			'theme_id' => null,
			'new_window' => true
		];

		$this->set(compact('data', 'sample'));
		$this->view = 'BuzzAdverts.examples';

		return;
	}

	/**
	 * Defines a whitelist of columns to be displayed on the admin index.
	 *
	 * @return array whitelisted columns
	 */
	protected function _adminIndexColumnsWhitelist() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumnsWhitelist();

		$columns[] = $modelAlias . '.view_template';

		return $columns;
	}

}
