<?php
class BuzzAdvertsStyle5 extends CakeMigration {

	/**
	 * Migration description
	 *
	 * @var string
	 */
	public $description = 'BuzzAdverts_initial_migration';

	/**
	 * Actions to be performed
	 *
	 * @var array $migration
	 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'advert_templates' => array(
					'is_themeable' => array('type' => 'boolean', 'null' => false, 'default' => '0', 'after' => 'has_image'),
				),
				'adverts' => array(
					'theme_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'key' => 'index', 'after' => 'url'),
				)
			)
		),
		'down' => array(
			'drop_field' => array(
				'advert_templates' => array('is_themeable'),
				'adverts' => array('theme_id'),
			),
		),
	);

	/**
	 * Before migration callback
	 *
	 * @param string $direction Direction of migration process (up or down)
	 * @return bool Should process continue
	 */
	public function before($direction) {
		return true;
	}

	/**
	 * After migration callback
	 *
	 * @param string $direction Direction of migration process (up or down)
	 * @return bool Should process continue
	 */
	public function after($direction) {
		if ($direction === 'up') {
			$data = [
				'name' => 'Style 5',
				'view_template' => 'BuzzAdverts.style5',
				'fields' => '["link_text"]',
				'has_image' => true,
				'is_themeable' => true,
				'is_active' => true
			];
			ClassRegistry::init('BuzzAdverts.AdvertTemplate')->save($data);
		}
		return true;
	}
}
