<?php
class BuzzAdvertsInitialMigration extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzAdverts_initial_migration';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'advert_relations' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'advert_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'model' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'foreign_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_advert_relations_adverts1' => array('column' => 'advert_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'advert_templates' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'view_template' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'fields' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'has_image' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'adverts' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'advert_template_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'view_template' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'heading_text' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'subheading_text' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'link_text' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'url' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'is_protected' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_adverts_advert_templates1' => array('column' => 'advert_template_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'advert_relations', 'advert_templates', 'adverts'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			// Insert the default templates.
			$data = array(
				array(
					'name' => 'Style 1',
					'view_template' => 'BuzzAdverts.style1',
					'fields' => '["link_text"]',
					'has_image' => true,
					'is_active' => true
				),
				array(
					'name' => 'Style 2',
					'view_template' => 'BuzzAdverts.style2',
					'fields' => '["heading_text", "subheading_text", "link_text"]',
					'has_image' => false,
					'is_active' => true
				),
				array(
					'name' => 'Style 3',
					'view_template' => 'BuzzAdverts.style3',
					'fields' => '["heading_text", "link_text"]',
					'has_image' => false,
					'is_active' => true
				),
				array(
					'name' => 'Style 4',
					'view_template' => 'BuzzAdverts.style4',
					'fields' => '["link_text"]',
					'has_image' => true,
					'is_active' => true
				),
				array(
					'name' => 'Image',
					'view_template' => 'BuzzAdverts.image',
					'fields' => '["link_text"]',
					'has_image' => true,
					'is_active' => true
				)
			);
			ClassRegistry::init('BuzzAdverts.AdvertTemplate')->saveMany($data);
			$data = array(
				array(
					'name' => 'Buy Gift Vouchers',
					'view_template' => 'BuzzAdverts.buy_gift_vouchers',
					'is_active' => false,
					'is_protected' => true
				),
				array(
					'name' => 'Redeem a Voucher',
					'view_template' => 'BuzzAdverts.redeem_voucher',
					'heading_text' => 'Already Have A voucher',
					'link_text' => 'Redeem It Here',
					'is_active' => false,
					'is_protected' => true
				),
				array(
					'name' => 'Facilities',
					'view_template' => 'BuzzAdverts.facilities',
					'is_active' => false,
					'is_protected' => true
				)
			);
			ClassRegistry::init('BuzzAdverts.Advert')->saveMany($data);
		}
		return true;
	}
}
